; ----------------------------------------------------
; PortableSumatraPDF
; ----------------------------------------------------
; Par Simon Leblanc
; Utilisant comme base de travail les scripts de John T. Haller et Sarkos et pyg
; License : GPL
; Ce script permet de crer le lanceur de PortableSumatraPDF.
; Compiler: NSIS (http://www.nullsoft.com).
; Require plugins: newadvsplash
; $id=PortableSumatraPDF.nsi $date=2007-07-27
; ----------------------------------------------------
;Copyright (C) 2005-2007 Framakey

;Website: http://www.framakey.org

;This software is OSI Certified Open Source Software.
;OSI Certified is a certification mark of the Open Source Initiative.

;This program is free software; you can redistribute it and/or
;modify it under the terms of the GNU General Public License
;as published by the Free Software Foundation; either version 2
;of the License, or (at your option) any later version.

;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.

;You should have received a copy of the GNU General Public License
;along with this program; if not, write to the Free Software
;Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
; ----------------------------------------------------
; Gnral
; ---- Modifiez les valeurs souhaites ----
; Dfinition variables entte
!define APPLANG "Fr"
!define NAME "PortableSumatraPDF"
!define FULLNAME "PortableSumatraPDF"
!define APP "SumatraPDF"
!define VER "0.6.0.0"
!define WEBSITE "http://www.framakey.org"
!define DEFAULTEXE "SumatraPDF.exe"
!define DEFAULTAPPDIR "SumatraPDF"
; Etiquette
  Caption "${FULLNAME} - Enfin un lecteur de PDF libre."

; ----------------------------------------------------
; ----  partir de l, vous n'avez normalement rien  modifier ---

; Nom de l'excutable
  Name "${NAME}"

; Icone
  Icon "${NAME}.ico"
  WindowIcon Off
; Nom du fichier  crer
  OutFile "${NAME}.exe"

; Runtime Switches
  SetDateSave on
  SetDatablockOptimize on
  CRCCheck On
  SilentInstall Silent
  AutoCloseWindow True

; ----------------------------------------------------
; Variables

  Var IniPath
  Var DataDir
  Var AppDirectory
  Var AppExecutable
  Var AdditionalParameters
  Var DisableSplashScreen
  Var Drive
  Var ExecString

; Inclusion langue franaise (ajout de sarkos)
LoadLanguageFile "${NSISDIR}\Contrib\Language Files\French.nlf"

; ----------------------------------------------------
; Version Informations

  VIProductVersion "${VER}"
  VIAddVersionKey FileDescription "${FULLNAME} pour Windows"
  VIAddVersionKey LegalCopyright "GPL"
  VIAddVersionKey Comments "Permet de lancer ${APP} (${APPLANG}) depuis un disque amovible. Pour plus de dtails, visitez ${WEBSITE}"
  VIAddVersionKey CompanyName "Framakey"
  VIAddVersionKey OriginalFilename "${NAME}.exe"
  VIAddVersionKey FileVersion "${VER}"

; ----------------------------------------------------
; Sections

Section "Main"

; Trouver le fichier INI, s'il y en a un
  IfFileExists "$EXEDIR\${NAME}.ini" "" CheckDataINI
    StrCpy "$IniPath" "$EXEDIR"
    Goto ReadINI

  CheckDataINI:
    Push "$EXEDIR"
    Call GetRoot
    Pop $0
    strcpy "$DataDir" "$0\Data\AppsData"
    IfFileExists "$DataDir\${APP}\${NAME}.ini" ""  NoINI
      StrCpy "$IniPath" "$DataDir\${APP}"
      Goto ReadINI

  ReadINI:
; Lit les paramtres du fichier INI
    ReadINIStr $0 "$IniPath\${NAME}.ini" "${NAME}" "${APP}Directory"
      StrCpy "$AppDirectory" "$EXEDIR\$0"

; Vrifie que les paramtres requis ci-dessus sont prsents
    IfErrors NoINI

    ReadINIStr $0 "$IniPath\${NAME}.ini" "${NAME}" "AdditionalParameters"
      StrCpy "$AdditionalParameters" $0
    ReadINIStr $0 "$IniPath\${NAME}.ini" "${NAME}" "${APP}Executable"
      StrCpy "$AppExecutable" $0
    ReadINIStr $0 "$IniPath\${NAME}.ini" "SplashScreen" "DisableSplashScreen"
      StrCpy "$DisableSplashScreen" $0

; Pour n'importe quelle paramtre du fichier INI non requis contenant une chaine vide, ignorer les erreurs associes
    ClearErrors

; Correct PROGRAMEXECUTABLE si paramtre vide
    StrCmp $AppExecutable "" "" EndINI
    StrCpy "$AppExecutable" "${DEFAULTEXE}"
    Goto EndINI

  NoINI:
; Pas de fichier INI, nous utiliserons les paramtres par dfaut
    StrCpy "$AdditionalParameters" ""
    StrCpy "$AppExecutable" "${DEFAULTEXE}"
    StrCpy "$DisableSplashScreen" "false"

    IfFileExists "$EXEDIR\${DEFAULTAPPDIR}\${DEFAULTEXE}" "" NoProgramEXE
      StrCpy "$AppDirectory" "$EXEDIR\${DEFAULTAPPDIR}"
      GoTo EndINI

  EndINI:
    IfFileExists "$AppDirectory\$AppExecutable" FoundProgramEXE

  NoProgramEXE:
; Si le chemin pointant vers l'excutable est invalide
    MessageBox MB_OK|MB_ICONEXCLAMATION `$AppExecutable est introuvable.  Vrifiez votre configuration`
    Abort

  FoundProgramEXE:
    StrCmp $DisableSplashScreen "true" CheckDrive
; Affiche le splash screen
    InitPluginsDir
    File /oname=$PLUGINSDIR\splash.jpg "${NAME}_splash.jpg"
		newadvsplash::show /NOUNLOAD 3000 200 200 -1 /L $PLUGINSDIR\splash.jpg

; Trouve la lettre du lecteur
  CheckDrive:
    Push "$EXEDIR"
    Call GetRoot
    Pop $0
    strcpy "$Drive" "$0"

; Check des paramtres
  GetAppParameters:
    Call GetParameters
    Pop $0

; Routine si pas de paramtres
  StrCmp "'$0'" "''" "" ExecWithParameters
  StrCpy $ExecString `"$AppDirectory\$AppExecutable"`
  Goto AdditionalParameters

; Routine si paramtres
  ExecWithParameters:
    StrCpy $ExecString `"$AppDirectory\$AppExecutable" $0`
    Goto ExecApp

  AdditionalParameters:
    StrCmp $AdditionalParameters "" ExecApp

; Additional Parameters
    StrCpy $ExecString `$ExecString $AdditionalParameters`

; Lancement De l'application
  ExecApp:
    Exec "$ExecString"

SectionEnd

Section .onInit
  Call Mutex
SectionEnd

; -------------------------------------------
; Obtenir les paramtres
; -------------------------------------------
Function "GetParameters"
  Push $R0
  Push $R1
  Push $R2
  StrCpy $R0 $CMDLINE 1
  StrCpy $R1 '"'
  StrCpy $R2 1
  StrCmp $R0 '"' loop
    StrCpy $R1 ' ' ; we're scanning for a space instead of a quote
  loop:
    StrCpy $R0 $CMDLINE 1 $R2
    StrCmp $R0 $R1 loop2
    StrCmp $R0 "\" "" "nofile"
      IntOp $2 $R2 + 1
    nofile:
    ;MessageBox MB_OK "r0: $R0"
    StrCmp $R0 "" loop2
    IntOp $R2 $R2 + 1
    Goto loop
  loop2:
    IntOp $R0 $R2 - $2
    IntOp $R0 $R0 - 4
    ;MessageBox MB_OK "$R2 - $2 = $R0"
    StrCpy $R7 $CMDLINE $R0 $2 ; we save the filename
    ;MessageBox MB_OK "$2"
  loop2b:
    IntOp $R2 $R2 + 1
    StrCpy $R0 $CMDLINE 1 $R2
    ;MessageBox MB_OK "rr0: $R0"
    StrCmp $R0 " " loop2b
  StrCpy $R0 $CMDLINE "" $R2
  Pop $R2
  Pop $R1
  Exch $R0
FunctionEnd

; -------------------------------------------
; Obtenir le chemin root
; Auteur : KiCHiK
; Source : http://nsis.sourceforge.net/Get_the_Root_Directory
; -------------------------------------------
Function GetRoot
  Exch $0
  Push $1
  Push $2
  Push $3
  Push $4

  StrCpy $1 $0 2
  StrCmp $1 "\\" UNC
    StrCpy $0 $1
    Goto done

UNC:
  StrCpy $2 3
  StrLen $3 $0
  loop:
    IntCmp $2 $3 "" "" loopend
    StrCpy $1 $0 1 $2
    IntOp $2 $2 + 1
    StrCmp $1 "\" loopend loop
  loopend:
    StrCmp $4 "1" +3
      StrCpy $4 1
      Goto loop
    IntOp $2 $2 - 1
    StrCpy $0 $0 $2

done:
  Pop $4
  Pop $3
  Pop $2
  Pop $1
  Exch $0
FunctionEnd

; -------------------------------------------
; Prvenir plusieurs Instances
; Sources : http://www.veekee.net/wikinsis/docs/AppendiceC.html#C.11
; -------------------------------------------
  Function Mutex
  System::Call 'kernel32::CreateMutexA(i 0, i 0, t "myMutex") i .r1 ?e'
  Pop $R0

  StrCmp $R0 0 +3
   MessageBox MB_OK|MB_ICONEXCLAMATION "${NAME} est dj lanc."
   Abort
  FunctionEnd

; -------------------------------------------
; Fin du script
